<?php

/** @var \Laravel\Lumen\Routing\Router $router */

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function () use ($router) {
    // return $router->app->version();
    return "This is API backend server. Try again";
});

$router->group(['prefix' => 'api'], function ($router) {
    $router->get('/test/backend', function () {
        return response()->json(["error" =>  false, "data" => [], "message" => "ok"]);
    });

    $router->post('/install', 'InstallationController@index');
    $router->get('/install/check', 'InstallationController@checkInstallation');
    $router->post('/register', 'AuthController@register');
    $router->post('/login', 'AuthController@login');

    $router->post('/password/email', 'PasswordController@postEmail');
    $router->post('password/reset', ['as' => 'password.reset', 'uses' => 'PasswordController@postReset']);
    $router->post('licence/store','InstallationController@saveLicenseData');
    $router->get('licence/show','InstallationController@getLicenseData');
        
    $router->group(['middleware' => 'auth'], function ($router) {

        /* User module routes*/
        $router->group(['prefix' => 'user'], function () use ($router) {
            $router->get('list', 'UserController@index');
            $router->post('store', 'UserController@store');
            $router->post('update', 'UserController@update');
            $router->post('updateOtherUser', 'UserController@updateOtherUser');
            $router->get('profile', 'UserController@profile');
            $router->post('fullprofile', 'UserController@userWiseProfile');
            $router->post('delete', 'UserController@delete');
            $router->post('deleteMultiUser', 'UserController@deleteMultiUser');
            $router->post('dropdownByRole', 'UserController@dropdownByRole'); // List of all users for dropdown use
        });

        $router->group(['prefix' => 'message'], function () use ($router) {
            $router->post('store', 'MessageController@storeConversation');
            $router->post('reply/{conversationId}', 'MessageController@storeReplyMessage');
            $router->get('sent', 'MessageController@getSentMessages');
            $router->get('inbox', 'MessageController@getInboxMessages');
            $router->get('conversation/{conversationId}', 'MessageController@getFullConversation');
            $router->post('conversation/{conversationId}/delete', 'MessageController@deleteConversation');
            $router->post('conversation/{conversationId}/message/{messageId}/delete', 'MessageController@deleteMessage');
            $router->post('conversation/delete-multi-conversation', 'MessageController@deleteMultiConversation');
            $router->post('conversation/{conversationId}/delete-multi-message', 'MessageController@deleteMultiMessage');
        });

        /* Role module routes*/
        $router->group(['prefix' => 'role'], function () use ($router) {
            $router->get('list', ['as' => 'role_list', 'uses' => 'RolesController@index']);
            $router->post('store', 'RolesController@store');
            $router->post('update', 'RolesController@update');
            $router->post('delete', 'RolesController@delete');
        });

        /* Product module routes*/
        $router->group(['prefix' => 'product'], function () use ($router) {
            $router->get('list', 'ProductController@index');
            $router->post('store', 'ProductController@store');
            $router->post('update', 'ProductController@update');
            $router->post('show', 'ProductController@show');
            $router->post('delete', 'ProductController@delete');
            $router->post('deleteMulti', 'ProductController@deleteMultiProduct');
            $router->post('makeArchive', 'ProductController@makeArchive');
            $router->get('archiveList', 'ProductController@archiveList');
            $router->get('produtcDropdown', 'ProductController@produtcDropdown');
        });

        /* AMC module routes*/
        $router->group(['prefix' => 'amc'], function () use ($router) {
            $router->get('list', 'AmcController@index');
            $router->post('store', 'AmcController@store');
            $router->post('update', 'AmcController@update');
            $router->post('show', 'AmcController@show');
            $router->post('delete', 'AmcController@delete');
            $router->post('deleteMultiAmc', 'AmcController@deleteMultiAmc');
            $router->post('updateStatus', 'AmcController@updateStatus');
            $router->post('rejectEmployeeStatus', 'AmcController@rejectEmployeeStatus');
            $router->post('approveEmployeeStatus', 'AmcController@approveEmployeeStatus');
        });

        /* Modules module routes*/
        $router->group(['prefix' => 'module'], function () use ($router) {
            $router->get('list', ['as' => 'module_list', 'uses' => 'ModuleController@index']);
        });

        /* Category module routes*/
        $router->group(['prefix' => 'category'], function () use ($router) {
            $router->get('list', 'CategoryController@index');
            $router->post('store', 'CategoryController@store');
            $router->post('delete', 'CategoryController@delete');
        });

        /* Service module routes*/
        $router->group(['prefix' => 'service'], function () use ($router) {
            $router->get('list', 'AmcServiceController@index');
            $router->post('store', 'AmcServiceController@store');
            $router->post('update', 'AmcServiceController@update');
            $router->post('show', 'AmcServiceController@show');
            $router->post('delete', 'AmcServiceController@delete');
            $router->post('deleteMultiService', 'AmcServiceController@deleteMultiService');
            // $router->post('updateStatus', 'AmcServiceController@updateStatus');
            $router->post('rejectEmployeeStatus', 'AmcServiceController@rejectEmployeeStatus');
            $router->post('approveEmployeeStatus', 'AmcServiceController@approveEmployeeStatus');
        });

        /* Purchase module routes*/
        $router->group(['prefix' => 'purchase'], function () use ($router) {
            $router->get('list', 'PurchaseController@index');
            $router->post('store', 'PurchaseController@store');
            $router->post('update', 'PurchaseController@update');
            $router->post('show', 'PurchaseController@show');
            $router->post('delete', 'PurchaseController@delete');
            $router->post('deleteMulti', 'PurchaseController@deleteMulti');
        });

        /* Stock module routes*/
        $router->group(['prefix' => 'stock'], function () use ($router) {
            $router->get('list', 'StockController@index');
            $router->post('show', 'StockController@show');
        });

        /* Tax module routes*/
        $router->group(['prefix' => 'tax'], function () use ($router) {
            $router->get('list', 'TaxController@index');
            $router->post('store', 'TaxController@store');
            $router->post('update', 'TaxController@update');
            $router->post('show', 'TaxController@show');
            $router->post('delete', 'TaxController@delete');
            $router->post('deleteMulti', 'TaxController@deleteMulti');
        });

        /* Quotation module routes*/
        $router->group(['prefix' => 'quotation'], function () use ($router) {
            $router->get('list', 'QuotationController@index');
            $router->post('store', 'QuotationController@store');
            $router->post('update', 'QuotationController@update');
            $router->post('show', 'QuotationController@show');
            $router->post('delete', 'QuotationController@delete');
            $router->post('deleteMulti', 'QuotationController@deleteMultiQuotation');
        });

        /* Sales module routes*/
        $router->group(['prefix' => 'sale'], function () use ($router) {
            $router->get('list', 'SaleController@index');
            $router->post('store', 'SaleController@store');
            $router->post('update', 'SaleController@update');
            $router->post('show', 'SaleController@show');
            $router->post('delete', 'SaleController@delete');
            $router->post('deleteMulti', 'SaleController@deleteMultiQuotation');
            $router->post('addPayment', 'SaleController@addPayment');
        });

        /* Sales module routes*/
        $router->group(['prefix' => 'complaint'], function () use ($router) {
            $router->get('list', 'ComplaintController@index');
            $router->post('store', 'ComplaintController@store');
            $router->post('update', 'ComplaintController@update');
            $router->post('show', 'ComplaintController@show');
            $router->post('delete', 'ComplaintController@delete');
            $router->post('deleteMulti', 'ComplaintController@deleteMultiComplaint');
        });

        /* Task module routes*/
        $router->group(['prefix' => 'task'], function () use ($router) {
            $router->get('list', 'TaskController@index');
            $router->post('store', 'TaskController@store');
            $router->post('update', 'TaskController@update');
            $router->post('show', 'TaskController@show');
            $router->post('delete', 'TaskController@delete');
            $router->post('deleteMulti', 'TaskController@deleteMultiTask');
            $router->post('rejectEmployeeStatus', 'TaskController@rejectEmployeeStatus');
            $router->post('approveEmployeeStatus', 'TaskController@approveEmployeeStatus');
        });

        /* Report module routes*/
        $router->group(['prefix' => 'report'], function () use ($router) {
            $router->post('complaintReport', 'ReportController@complaintReport');
            $router->post('saleReport', 'ReportController@saleReport');
            $router->post('serviceReport', 'ReportController@serviceReport');
        });

        $router->group(['prefix' => 'income'], function ($router) {
            $router->post('store', 'IncomeController@store');
            $router->get('list', 'IncomeController@index');
            $router->post('update', 'IncomeController@update');
            $router->post('delete', 'IncomeController@destroy');
            $router->post('monthly/report', 'IncomeController@monthlyReport');
        });

        $router->group(['prefix' => 'expense'], function ($router) {
            $router->post('store', 'ExpenseController@store');
            $router->get('list', 'ExpenseController@index');
            $router->post('update', 'ExpenseController@update');
            $router->post('delete', 'ExpenseController@destroy');
            $router->post('monthly/report', 'ExpenseController@monthlyReport');
        });

        /* Task module routes*/
        $router->group(['prefix' => 'template'], function () use ($router) {
            $router->get('list', 'EmailTemplateController@index');
            $router->post('store', 'EmailTemplateController@store');
            $router->post('update', 'EmailTemplateController@update');
            $router->post('show', 'EmailTemplateController@show');
            $router->post('delete', 'EmailTemplateController@delete');
            $router->post('deleteMulti', 'EmailTemplateController@deleteMultiTask');
            $router->post('rejectEmployeeStatus', 'EmailTemplateController@rejectEmployeeStatus');
            $router->post('approveEmployeeStatus', 'EmailTemplateController@approveEmployeeStatus');
        });

        /* Setting module routes*/
        $router->group(['prefix' => 'setting'], function () use ($router) {
            $router->get('list', 'SettingController@index');
            $router->post('store', 'SettingController@store');
            $router->post('update', 'SettingController@update');
            $router->post('show', 'SettingController@show');
            $router->post('delete', 'SettingController@delete');
            $router->post('deleteMulti', 'SettingController@deleteMultiTask');
            $router->post('rejectEmployeeStatus', 'SettingController@rejectEmployeeStatus');
            $router->post('approveEmployeeStatus', 'SettingController@approveEmployeeStatus');
        });

        /* Dashboard module routes*/
        $router->group(['prefix' => 'dashboard'], function () use ($router) {
            $router->get('data', 'DashboardController@index'); // List of all users for dropdown use
            $router->get('sidemenu', 'DashboardController@sidemenu');
        });
        $router->get('activitylog', 'ActivityLogController@index'); // List of all users for dropdown use
        $router->get('notification', 'NotificationsController@getNotifications'); // List of all users for dropdown use
        $router->post('deleteNotification', 'NotificationsController@deleteNotifications'); // List of all users for dropdown use
        // $router->get('listenEventMessage', 'EventMessagesController@sendRoleUpdates');
    });
});
