<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use \App\Models\Module;

class PermissionSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Reset cached roles and permissions
        // app()['cache']->forget('maklad.permission.cache');
        app()->make(\Spatie\Permission\PermissionRegistrar::class)->forgetCachedPermissions();

        // $modules = Module::orderBy('created_at', 'desc')->take(5)->get();
        $modules = Module::orderBy('created_at', 'desc')->get();
        foreach ($modules as $module) {
            \Spatie\Permission\Models\Permission::create(['name' => $module->tag . '_view']);
            \Spatie\Permission\Models\Permission::create(['name' => $module->tag . '_add']);
            \Spatie\Permission\Models\Permission::create(['name' => $module->tag . '_edit']);
            \Spatie\Permission\Models\Permission::create(['name' => $module->tag . '_delete']);
            \Spatie\Permission\Models\Permission::create(['name' => $module->tag . '_own_data']);
        }
    }
}
