<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddUpdatedAtAndCreatedAtToNotificationsAndActivityLogs extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('notifications', function (Blueprint $table) {
            // Add nullable dateTime columns for updated_at and created_at
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('created_at')->nullable();
        });
        Schema::table('activity_logs', function (Blueprint $table) {
            // Add nullable dateTime columns for updated_at and created_at
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('created_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('notifications', function (Blueprint $table) {
            // Drop the columns if rolling back
            $table->dropColumn('updated_at');
            $table->dropColumn('created_at');
        });
        Schema::table('activity_logs', function (Blueprint $table) {
            // Drop the columns if rolling back
            $table->dropColumn('updated_at');
            $table->dropColumn('created_at');
        });
    }
}
