<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->longText('first_name')->nullable();
            $table->longText('last_name')->nullable();
            $table->longText('gender')->nullable();
            $table->longText('birth_date')->nullable();
            $table->longText('address')->nullable();
            $table->longText('city')->nullable();
            $table->longText('state')->nullable();
            $table->longText('pincode')->nullable();
            $table->longText('mobile')->nullable();
            $table->longText('email')->nullable();
            $table->longText('password')->nullable();
            $table->longText('unique_identity')->nullable();
            $table->integer('role_id')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('created_at')->nullable();
            $table->longText('profile')->nullable();
            $table->longText('account_number')->nullable();
            $table->longText('bank_name')->nullable();
            $table->longText('branch_name')->nullable();
            $table->longText('swift_code')->nullable();
            $table->longText('branch_code')->nullable();
            $table->longText('international_bank_code')->nullable();
            $table->longText('national_bank_code')->nullable();
            $table->longText('gst')->nullable();
            $table->longText('company_name')->nullable();
            $table->longText('company_contact_person')->nullable();
            $table->longText('ifsc_code')->nullable();
            $table->longText('tin_no')->nullable();
            $table->longText('cst_no')->nullable();
            $table->longText('pan_no')->nullable();
            $table->longText('phone')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
