<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->longText('name')->nullable();
            $table->longText('model_number')->nullable();
            $table->longText('price')->nullable();
            $table->longText('brand_id')->nullable();
            $table->longText('category_id')->nullable();
            $table->longText('unit_id')->nullable();
            $table->longText('image')->nullable();
            $table->longText('description')->nullable();
            $table->longText('product_identity')->nullable();
            $table->integer('is_archive')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('created_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
};
