<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model as Eloquent;

class Stock extends Eloquent
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'product_id', 'stock'
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function history()
    {
        return $this->hasMany(PurchaseProducts::class, 'product_id', 'product_id');
    }
}
