<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Notifications extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id', // The ID of the user to whom the notification is sent,
        'target_id',
        'updated_by',
        'content', // The content of the notification
        'is_read', // Flag to mark if the notification has been read
        'path',
    ];

    /**
     * Retrieve the user associated with the notification.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

/**
 * Create and send multiple notifications.
 *
 * @param  array  $notifications
 * @return void
 */
public static function send(array $notifications)
{
    foreach ($notifications as $notification) {
        static::create([
            'user_id' => $notification['user_id'],
            'target_id' => $notification['target_id'],
            'updated_by' => $notification['updated_by'],
            'content' => $notification['content'],
            'is_read' => $notification['is_read'] ?? 0, // Set as unread (0) by default if not provided
            'path' => $notification['path']
        ]);
    }
}
}
