<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Income extends Model
{
    public const INCOME_CREATE_ACTIVITY = 'Income Created';
    public const INCOME_UPDATE_ACTIVITY = 'Income Updated';
    public const INCOME_DELETE_ACTIVITY = 'Income Deleted';
    
    protected $fillable = [
        "customer_id",
        "status_id",
        "date",
        "label",
        "entries",
    ];

    protected $dates = [
        "date"
    ];

    public function customer()
    {
        return $this->belongsTo(User::class, "customer_id");
    }

    public function status()
    {
        return $this->belongsTo(Category::class, 'status_id');
    }
}
