<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ConversationMessage extends Model
{
    protected $fillable = ['conversation_id', 'sender_id', 'subject', 'attachment', 'message_comment', 'send_by', 'read_by', 'deleted_by'];

    protected $casts = [
        'read_by' => 'array',
        'deleted_by' => 'array',
    ];

    public function conversation()
    {
        return $this->belongsTo(Conversation::class);
    }

    public function sender()
    {
        return $this->belongsTo(User::class, 'created_by')->withDefault(['full_name' => 'Unknown']);
    }
    protected static function booted()
    {
        static::creating(function ($model) {
            if (! $model->created_by) {
                $model->created_by = auth()->id();
            }
        });
    }

    public function markAsRead($userId)
    {
        $readBy = $this->read_by ?? [];
        if (!in_array($userId, $readBy)) {
            $readBy[] = $userId;
            $this->update(['read_by' => $readBy]);
        }
    }

    public function softDeleteMessage($userId)
    {
        $deletedBy = $this->deleted_by ?? [];
        if (!in_array($userId, $deletedBy)) {
            $deletedBy[] = $userId;
            $this->update(['deleted_by' => $deletedBy]);
        }
    }
}
