<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ActivityLog extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'updated_by', 'activity', 'activity_slug', 'target_name', 'details',
    ];

    /**
     * Retrieve the user associated with the activity.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Create an activity log entry.
     *
     * @param  string  $updatedby
     * @param  string  $activity
     * @param  string  $activity_slug
     * @param  string|null  $details
     * @param  string|null  $targetname
     * @return ActivityLog
     */
    public static function log(array $data): ActivityLog
    {
        return static::create([
            'updated_by' => $data['updated_by'],
            'activity' => $data['activity'],
            'activity_slug' => $data['activity_slug'],
            'target_name' => $data['target_name'] ?? null,
            'details' => $data['details'] ?? null,
        ]);
    }
}
