<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class TemplateResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'template_type_id' => ($this->template_type_id)?$this->template_type_id:null,
            'template_type' => ($this->templateType)?new CategoryResource($this->templateType):null,
            'subject' => ($this->subject)?$this->subject:null,
            'body' => ($this->body)?$this->body:null,
        ];
    }
}
