<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class StockResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'stock' => ($this->stock)?$this->stock:null,
            'product_id' => ($this->product_id)?$this->product_id:null,
            'product' => ($this->product)?$this->product:null,
            'category' => ($this->product->category) ? new CategoryResource($this->product->category) : null,
            'history' => ($this->history)?StockHistoryResource::collection($this->history):null,
        ];
    }
}
