<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class StockHistoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'date' => ($this->created_at)?getDateF($this->created_at):null,
            'quantity' => ($this->quantity)?$this->quantity:null,
            'rate' => ($this->rate)?$this->rate:null,
            'amount' => ($this->amount)?$this->amount:null,
            'supplier_id' => ($this->purchase->supplier_id)?$this->purchase->supplier_id:null,
            'supplier' => ($this->purchase->supplier)?$this->purchase->supplier->full_name:null,
            
        ];
    }
}
