<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class SettingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'system_name' => ($this->system_name) ? $this->system_name : 'Annual Maintenance System',
            'email' => ($this->email) ? $this->email : 'amc@gmail.com',
            'starting_year' => ($this->starting_year) ? $this->starting_year : date('Y'),
            'address' => ($this->address) ? $this->address : 'India',
            'office_phone_number' => ($this->office_phone_number) ? $this->office_phone_number : '',
            'country' => ($this->country) ? $this->country : '91',
            'system_language' => ($this->system_language) ? $this->system_language : 'en',
            'rtl' => ($this->rtl) ? $this->rtl : 'false',
            'date_formate' => ($this->date_formate) ? $this->date_formate : 'MMMM DD, YYYY',
            'currency_code' => ($this->currency_code) ? $this->currency_code : '₹',
            'footer_text' => ($this->footer_text) ? $this->footer_text : 'All rights reserved by AMC Master',
            'time_zone' => ($this->time_zone) ? $this->time_zone : 'UTC',
            'logo' => ($this->logo) ?  url('storage/' . $this->logo) : '',
            'sidebar_logo' => ($this->sidebar_logo != '') ?  url('storage/' . $this->sidebar_logo) : '',
        ];
    }
}
