<?php

namespace App\Http\Resources;

use App\Models\Module;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Http\Resources\Json\ResourceCollection;

class RoleResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        // $permissions = null;

        // if (isset($this->permission_ids)) {
        //     $permissions = !empty($this->permission_ids) ? PermissionResource::collection($this->whenLoaded('permissions')) : null;
        // }
        $moduleData = Module::select('id', 'name', 'tag', 'view', 'delete', 'add', 'edit', "{$this->name}_own_data as own_data")->get();
        return [
            'id' => $this->id,
            'name' => $this->name,
            // 'permissions' => $permissions,
            'permissions' => PermissionResource::collection($this->permissions),
            // 'permissions' => $this->permission_ids,
            'modules' => ModuleResource::collection($moduleData),
        ];
    }
}
