<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class QuotationProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'quantity' => ($this->quantity)?$this->quantity:null,
            'rate' => ($this->rate)?$this->rate:null,
            'amount' => ($this->amount)?$this->amount:null,
            'product_id' => ($this->product_id)?$this->product_id:null,
            'product_name' => ($this->product)?$this->product->name:null,
        ];
    }
}
