<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PurchaseResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'purchase_no' => ($this->purchase_no)?$this->purchase_no:null,
            'date' => ($this->date)?getDateF($this->date):null,
            'contact_person' => ($this->contact_person)?$this->contact_person:null,
            'status_id' => ($this->status)?$this->status:null,
            'status' => ($this->purchaseStatus)?$this->purchaseStatus->value:null,
            'supplier_id' => ($this->supplier_id)?$this->supplier_id:null,
            'supplier' => ($this->supplier)?new UserResource($this->supplier):null,
            'product_details' => ($this->productDetails)?PurchaseProductResource::collection($this->productDetails):null,
        ];
    }
}
