<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'product_identity' => $this->product_identity,
            'name' => $this->name,
            'model_number' => $this->model_number,
            'brand_id' => ($this->brand_id) ? $this->brand_id : null,
            'brand' => ($this->brand) ? new CategoryResource($this->brand) : null,
            'category_id' => $this->category_id ? $this->category_id : null,
            'category' => ($this->category) ? new CategoryResource($this->category) : null,
            'price' => $this->price,
            'unit_id' => $this->unit_id ? $this->unit_id : null,
            'unit' => ($this->unit) ? new CategoryResource($this->unit) : null,
            'image' => ($this->image) ?  url('storage/' . $this->image) : url('storage/images/product/product.png'),
            'description' => $this->description,
            'is_archive' => $this->is_archive,
            'stock' => ($this->stock) ? new StockResource($this->stock) : null,
        ];
    }
}
