<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ExpenseMonthlyReportResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $entries = collect(json_decode($this->entries));
        $totalExpense = $entries->sum('amount');
        return [
            "id" => $this->id,
            "label" => $this->label,
            "date" => $this->date->format('d-m-Y'),
            "total_expense" => $totalExpense
        ];
    }
}
