<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class DashboardComplaintResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => ($this->id)?$this->id:'N/A',
            'customer_name' => ($this->customer)?$this->customer->full_name:'N/A',
            'complaint_no' => ($this->complaint_no)?$this->complaint_no:'N/A',
            'assign_date' => ($this->assign_date)?getDateF($this->assign_date):'N/A',
            'assign_to' => ($this->assignTo)?$this->assignTo->full_name:'N/A',
            'status' => ($this->status)?$this->status->value:'N/A',
        ];
    }
}
