<?php

namespace App\Http\Resources;

use App\Models\Amc;
use App\Models\AmcService;

use Illuminate\Http\Resources\Json\JsonResource;

class CustomerProfileResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $customerAmcIds = Amc::where(['customer' => $this->id])->pluck('id');
        $services = AmcService::whereIn('amc_id', $customerAmcIds)->get();

        return [
            'id' => $this->id,
            'unique_identity' => $this->unique_identity,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'full_name' => $this->full_name,
            'gender' => $this->gender,
            'email' => $this->email,
            'profile' => ($this->profile) ?  url('storage/' . $this->profile) : url('storage/images/user/' . $this->gender . '.jpg'),
            'birth_date' => $this->birth_date,
            'mobile' => $this->mobile,
            'role_id' => $this->role_id,
            'role_name' => $this->getRole(),

            'company_name' => $this->company_name,
            'company_contact_person' => $this->company_contact_person,
            'account_number' => $this->account_number,
            'ifsc_code' => $this->ifsc_code,
            'branch_name' => $this->branch_name,
            'tin_no' => $this->tin_no,
            'cst_no' => $this->cst_no,
            'pan_no' => $this->pan_no,
            'phone' => $this->phone,
            'address' => $this->address,
            'city' => $this->city,
            'state' => $this->state,
            'pincode' => $this->pincode,
            'bank_name' => ($this->bank_name) ? $this->bank_name : null,
            'swift_code' => ($this->swift_code) ? $this->swift_code : null,
            'branch_code' => ($this->branch_code) ? $this->branch_code : null,
            'national_bank_code' => ($this->national_bank_code) ? $this->national_bank_code : null,
            'international_bank_code' => ($this->international_bank_code) ? $this->international_bank_code : null,
            'gst' => ($this->gst) ? $this->gst : null,
            'customer_contacts' => ($this->customerContacts && count($this->customerContacts)) ? $this->customerContacts : null,
            'quotation' => ($this->quotations) ? QuotationResource::collection($this->quotations) : null,
            'complaint' => ($this->complaints) ? ComplaintResource::collection($this->complaints) : null,
            'sale' => ($this->sales) ? SaleResource::collection($this->sales) : null,
            'services' => ($services) ? AmcServiceResource::collection($services) : null
        ];
    }
}
