<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ConversationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {   
        return [
            'id' => $this->id,
            'subject' => $this->subject,
            'attachment' => ($this->attachment) ?  url('storage/' . $this->attachment) : url('storage/images/service/noimage.png'),
            'message_comment' => $this->message_comment,
            'sms_text' => $this->sms_text,
            'send_sms' => $this->send_sms,
            'send_mail' => $this->send_mail,
            'created_by' => $this->owner->full_name,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'message_for' => $this->message_for,
            'members' => ConversationMemberResource::collection($this->whenLoaded('members')),
            'messages' => ConversationMessageResource::collection($this->whenLoaded('messages')),
        ];
    }
}
