<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ComplaintResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    { 
        return [
            'id' => ($this->id) ? $this->id : null,
            'complaint_no' => ($this->complaint_no) ? $this->complaint_no : null,
            'date' => ($this->date) ? getDateF($this->date) : null,
            'complaint_time' => ($this->complaint_time) ? date('H:i:s', strtotime($this->complaint_time)) : null,
            'assign_date' => ($this->assign_date) ? getDateF($this->assign_date) : null,
            'description' => ($this->description) ? $this->description : null,
            'attachment' => ($this->attachment) ?  url('storage/' . $this->attachment) : url('storage/images/complaint/amc.jpg'),
            'status_id' => ($this->status_id) ? $this->status_id : null,
            'status' => ($this->status) ? $this->status->value : null,
            'complaint_type_id' => ($this->complaint_type_id) ? $this->complaint_type_id : null,
            'complaint_type' => ($this->complaintType) ? $this->complaintType->value : null,
            'customer_id' => ($this->customer_id) ? $this->customer_id : null,
            'customer' => ($this->customer) ? new UserResource($this->customer) : null,
            'assign_to_id' => ($this->assign_to_id) ? $this->assign_to_id : null,
            'assign_to' => ($this->assignTo) ? new UserResource($this->assignTo) : null,
            'product_id' => ($this->product_id) ? $this->product_id : null,
            'product' => ($this->product) ? new ProductResource($this->product) : null
        ];
    }
}
