<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AmcProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'product_note' => $this->product_note,
            // 'product_id' => ($this->amc_product)?$this->amc_product:null,
            'product_id' => ($this->product) ? $this->product->id : null,
            'product' => ($this->product) ? new ProductResource($this->product) : null,
        ];
    }
}
