<?php

use Carbon\Carbon;
use App\Models\User;
use App\Models\AmcService;
use App\Models\Category;
use App\Models\EmailTemplate;
use App\Models\Setting;
use App\Models\Task;
use Illuminate\Support\Facades\Mail;
use App\Mail\ServiceBeforeDay;
use App\Mail\EmployeeDailyTask;
use App\Mail\MonthlyService;

if (!function_exists('app_path')) {
    /**
     * Get the path to the application folder.
     *
     * @param  string $path
     * @return string
     */
    function app_path($path = '')
    {
        return app('path') . ($path ? DIRECTORY_SEPARATOR . $path : $path);
    }
}

function getHost()
{
    return request()->getHost();
};

function categoryLabel($categoryId)
{
    $category = Category::find($categoryId);
    return ($category) ? $category->value : '';
};

function getUniqueStamp()
{
    return (int)round(microtime(true) * 1000 * rand(100, 999));
};

function getDateF($date)
{
    // return Carbon::createFromFormat('Y-m-d', $date)->format('d-m-Y');
    return Carbon::parse($date)->format('d-m-Y');
};

function getEmailContent($mailFor)
{
    $templateType = Category::where(['key' => 'email_template_types', 'value' => $mailFor])->first();
    if ($templateType) {
        $content = EmailTemplate::where(['template_type_id' => $templateType->id])->first();
        return ($content) ? $content : '';
    } else {
        return '';
    }
};

function getSetting($key)
{
    $setting = Setting::get();
    if ($setting->first()) {
        return $setting->first()->$key;
    } else {
        return '';
    }
};

function dailyReminder()
{
    $setting = Setting::get();

    //Daily reminder
    if ($setting->first()->daily_reminder_last_date != date('Y-m-d')) {
        // Employee task list
        $employees = User::role(['employee'])->get();
        foreach ($employees as $employee) {
            $tasks = Task::where(['assign_to_id' => $employee->id, 'assign_date' => date('Y-m-d')])->get();

            if (!$tasks->isEmpty()) {
                $message = "<table>
                                <tr>
                                <th>Customer</th>
                                <th>Date</th>
                                <th>Description</th>
                            </tr>";
                foreach ($tasks as $task) {
                    $message .= "<tr>
                                <th>" . $task->customer->full_name . "</th>
                                <th>" . date('d-m-Y', strtotime($task->date)) . "</th>
                                <th>" . $task->description . "</th>
                            </tr>";
                }
                $message .= "</table>";

                $systemName = getSetting('system_name');
                // Get email template content using helper
                $emailTemplate = getEmailContent('employee_task_list');
                $logo = getSetting('logo');
                $logo_image = url('storage/' . $logo);
                $footer_image = url('storage/email_image/footer.png');
                $support_image = url('storage/email_image/support.png');
                $service_image = url('storage/email_image/service.png');
                $history_image = url('storage/email_image/history.png');

                if ($emailTemplate) {
                    $mailformat = $emailTemplate->body;
                    $serch = array('{ employee }', '{ today_date }', '{ task_list }', '{ systemname }');
                    $replace = array($employee->full_name, date('d-m-Y'), $message, $systemName);
                    $message_content = str_replace($serch, $replace, $mailformat);

                    // Welcome Mail
                    $mailData = [
                        'host' => getHost(),
                        'subject' => $emailTemplate->subject,
                        'content' => $message_content,
                        'logo_image' => $logo_image,
                        'footer_image' => $footer_image,
                        'support_image' => $support_image,
                        'service_image' => $service_image,
                        'history_image' => $history_image
                    ];

                    Mail::to($employee->email)->send(new EmployeeDailyTask($mailData));
                }
            }
        }

        // Service reminder to customer
        $services = AmcService::where(['service_date' => date('d-m-Y', strtotime("+1 day"))])->get();

        if (!$services->isEmpty()) {
            foreach ($services as $service) {
                $systemName = getSetting('system_name');
                // Get email template content using helper
                $emailTemplate = getEmailContent('service_before_day');
                $logo = getSetting('logo');
                $logo_image = url('storage/' . $logo);
                $footer_image = url('storage/email_image/footer.png');
                $support_image = url('storage/email_image/support.png');
                $service_image = url('storage/email_image/service.png');
                $history_image = url('storage/email_image/history.png');

                if ($emailTemplate) {
                    $mailformat = $emailTemplate->body;
                    $serch = array('{ username }', '{ service_title }', '{ service_date }', '{ systemname }');
                    $replace = array($service->amc->client->full_name, $service->service_label, $service->service_date, $systemName);
                    $message_content = str_replace($serch, $replace, $mailformat);

                    // Welcome Mail
                    $mailData = [
                        'host' => getHost(),
                        'subject' => $emailTemplate->subject,
                        'content' => $message_content,
                        'logo_image' => $logo_image,
                        'footer_image' => $footer_image,
                        'support_image' => $support_image,
                        'service_image' => $service_image,
                        'history_image' => $history_image
                    ];

                    Mail::to($service->amc->client->email)->send(new ServiceBeforeDay($mailData));
                }
            }
        }


        if ($setting->first()) {
            $setting->first()->update(["daily_reminder_last_date" => date('Y-m-d')]);
        }
    }


    //Monthly service list to admin
    $currentMonth = Carbon::now()->endOfMonth()->format('m-Y');
    $lastMailMonth = date('m-Y', strtotime($setting->first()->monthly_reminder_last_date));

    $todayDate = Carbon::now()->format('d-m-Y');

    $monthLastDate = Carbon::now()->endOfMonth()->format('d-m-Y');

    if ($currentMonth != $lastMailMonth && $todayDate == $monthLastDate)
    // if($currentMonth != $lastMailMonth)
    {
        $start = Carbon::now()->startOfMonth()->format('d-m-Y');
        $end = Carbon::now()->endOfMonth()->format('d-m-Y');

        $services = AmcService::whereBetween('service_date', [$start, $end])->get();

        if (!$services->isEmpty()) {
            $message = "<table>
                            <tr>
                            <th>Customer</th>
                            <th>Date</th>
                            <th>Description</th>
                        </tr>";
            foreach ($services as $service) {
                $message .= "<tr>
                            <th>" . $service->amc->client->full_name . "</th>
                            <th>" . $service->service_date . "</th>
                            <th>" . $service->service_label . "</th>
                        </tr>";
            }
            $message .= "</table>";

            $systemName = getSetting('system_name');
            $systemEmail = getSetting('email');

            $admin = User::role(['admin'])->get();
            $adminName = $admin->first()->full_name;

            // Get email template content using helper
            $emailTemplate = getEmailContent('service_list_monthly');
            $logo = getSetting('logo');
            $logo_image = url('storage/' . $logo);
                $footer_image = url('storage/email_image/footer.png');
                $support_image = url('storage/email_image/support.png');
                $service_image = url('storage/email_image/service.png');
                $history_image = url('storage/email_image/history.png');

            if ($emailTemplate) {
                $mailformat = $emailTemplate->body;
                $serch = array('{ admin }', '{ service_list }', '{ systemname }');
                $replace = array($adminName, $message, $systemName);
                $message_content = str_replace($serch, $replace, $mailformat);

                // Welcome Mail
                $mailData = [
                    'host' => getHost(),
                    'subject' => $emailTemplate->subject,
                    'content' => $message_content,
                    'logo_image' => $logo_image,
                        'footer_image' => $footer_image,
                        'support_image' => $support_image,
                        'service_image' => $service_image,
                        'history_image' => $history_image
                ];

                Mail::to($systemEmail)->send(new MonthlyService($mailData));
            }
        }

        if ($setting->first()) {
            $setting->first()->update(["monthly_reminder_last_date" => date('Y-m-d')]);
        }
    }
}

if (!function_exists('public_path')) {

    /**
     * Return the path to public dir
     * @param null $path
     * @return string
     */
    function public_path($path = null)
    {
        return rtrim(app()->basePath('public/' . $path), '/');
    }
}

if (!function_exists('resource_path')) {

    /**
     * Return the path to resource dir
     * @param null $path
     * @return string
     */
    function resource_path($path = null)
    {
        return app()->resourcePath($path);
    }
}

if (!function_exists('formatDate')) {
    function formatDate($date, $format = null)
    {
        if (!$format) {
            $format = getSetting('date_formate');
        }

        switch ($format) {
            case 'DD-MM-YYYY':
                return date('d-m-Y', strtotime($date));
            case 'MM-DD-YYYY':
                return date('m-d-Y', strtotime($date));
            case 'YYYY-MM-DD':
                return date('Y-m-d', strtotime($date));
            case 'MMMM DD, YYYY':
                return date('F d, Y', strtotime($date));
            default:
                return $date; // fallback to original format if not matched
        }
    }
}