<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use App\Models\User;
use App\Models\ActivityLog;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\SettingResource;
use Tymon\JWTAuth\Exceptions\UserNotDefinedException;

class SettingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {
            $setting = Setting::Orderby('created_at', 'desc')->get();

            return (new SettingResource($setting->first()))->additional(["error" => false, "message" => '']);
            // return response()->json([
            //     'data' => $setting,
            //     'error' => false,
            //     'message' => ""
            // ]);
        } catch (UserNotDefinedException $e) {
            $this->setResponse(true, $e->getMessage());
            return response()->json($this->_response, 500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'system_name' => 'required',
            'starting_year' => 'required|numeric',
            'address' => 'required',
            'office_phone_number' => 'required|digits_between:10,15',
            'country' => 'required',
            'system_language' => 'required',
            'rtl' => 'required|in:true,false',
            'date_formate' => 'required',
            'time_zone' => 'required',
            'logo' => 'required|mimes:jpg,bmp,png,jpeg,svg|max:2048',
            'footer_text' => 'required',
        ]);

        if ($validator->fails()) {
            $this->setResponse(true,  $validator->errors()->all());
            return response()->json($this->_response, 400);
        }

        try {
            if (auth()->user()->getRole() == 'admin' || auth()->user()->hasPermissionTo('setting_add')) {

                $setting = Setting::create($request->except('logo'));

                if ($request->has('logo')) {

                    $logo = $this->uploadFile($request->logo, 'images/logo');
                    if ($logo != false) {
                        $setting->logo = $logo;
                    }
                }

                if ($request->has('sidebar_log')) {

                    $sidebar_log = $this->uploadFile($request->sidebar_log, 'images/logo');
                    if ($sidebar_log != false) {
                        $setting->sidebar_log = $sidebar_log;
                    }
                }
                $setting->save();

                $sourceName = auth()->id();
                $users = User::find($sourceName);
                $sourceId = $users ? $users->first_name : 'Unknown User';
            $data = [
                'updated_by' => $sourceId,
                'activity' => Setting::SETTING_UPDATE_ACTIVITY,
                'activity_slug' =>Str::of(Setting::SETTING_UPDATE_ACTIVITY)->slug('_'),
                'target_name' => $setting->system_name,
                'details' => 'Settings updated for ' . $setting->system_name,
            ];
            ActivityLog::log($data);
                $this->_response['data'] = '';
                $this->setResponse(false, 'Settings updated successfully.');
                return response()->json($this->_response);
            } else {
                $data = [
                    'error' => true,
                    'message' => 'Unauthorized',
                    'error_code' => 401
                ];
                return response()->json($data, 401);
            }
        } catch (\Exception $e) {
            $this->setResponse(true,  $e->getMessage());
            return response()->json($this->_response, 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function show(Setting $setting)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function edit(Setting $setting)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            // 'id' => 'required|exists:settings,id',
            'email' => 'required|email',
            'system_name' => 'required',
            'starting_year' => 'required|numeric',
            'address' => 'required',
            'office_phone_number' => 'required|digits_between:10,15',
            'country' => 'required',
            'system_language' => 'required',
            'rtl' => 'required|in:true,false',
            'date_formate' => 'required',
            'currency_code' => 'required',
            'logo' => 'filled|mimes:jpg,bmp,png,jpeg,svg|max:2048',
            'sidebar_logo' => 'filled|mimes:jpg,bmp,png,jpeg,svg|max:2048',
            'footer_text' => 'required',
            'time_zone' => 'required',
        ]);

        if ($validator->fails()) {
            $this->setResponse(true,  $validator->errors()->all());
            return response()->json($this->_response, 400);
        }

        try {

            if (auth()->user()->getRole() == 'admin' || auth()->user()->hasPermissionTo('setting_edit')) {

                $setting = Setting::find($request->id);
                if ($setting) {
                    $setting->update($request->except(['logo', 'sidebar_logo']));
                } else {
                    $setting = Setting::create($request->except(['logo', 'sidebar_logo']));
                }

                if ($request->has('logo')) {

                    $logo = $this->uploadFile($request->logo, 'images/logo');
                    if ($logo != false) {
                        $setting->logo = $logo;
                    }
                }

                if ($request->has('sidebar_logo')) {

                    $sidebar_logo = $this->uploadFile($request->sidebar_logo, 'images/logo');
                    if ($sidebar_logo != false) {
                        $setting->sidebar_logo = $sidebar_logo;
                    }
                }
                $setting->save();

                $sourceName = auth()->id();
                $users = User::find($sourceName);
                $sourceId = $users ? $users->first_name : 'Unknown User';
            $data = [
                'updated_by' => $sourceId,
                'activity' => Setting::SETTING_UPDATE_ACTIVITY,
                'activity_slug' =>Str::of(Setting::SETTING_UPDATE_ACTIVITY)->slug('_'),
                'target_name' => $setting->system_name,
                'details' => 'Settings updated',
            ];
            ActivityLog::log($data);
                $this->_response['data'] = '';
                $this->setResponse(false, 'Setting updated successfully.');
                return response()->json($this->_response);
            } else {
                $data = [
                    'error' => true,
                    'message' => 'Unauthorized',
                    'error_code' => 401
                ];
                return response()->json($data, 401);
            }
        } catch (\Exception $e) {
            $this->setResponse(true,  $e->getMessage());
            return response()->json($this->_response, 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function destroy(Setting $setting)
    {
        //
    }
}
