<?php

namespace App\Http\Controllers;

use Exception;
// use Maklad\Permission\Models\Role;
// use Maklad\Permission\Models\Permission;
use Illuminate\Http\Request;
use App\Http\Resources\RoleResource;
use App\Models\ActivityLog;
use App\Models\User;
use App\Models\AmcOption;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Spatie\Permission\Models\Role;
use Tymon\JWTAuth\Exceptions\UserNotDefinedException;

class RolesController extends Controller
{
    // Roles List
    public function index()
    {
        try {
            $roleData = Role::all()->load('permissions');
            // return response()->json($roleData);

            return RoleResource::collection($roleData)->additional(["error" => false, "message" => 'Here is all roles data']);
        } catch (UserNotDefinedException $e) {
            $this->setResponse(true, $e->getMessage());
            return response()->json($this->_response, 500);
        }
    }

    // Add new role and assign permissions
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'permissions' => 'required|array',
        ]);

        if ($validator->fails()) {
            $this->setResponse(true, $validator->errors()->all());
            return response()->json($this->_response, 400);
        }

        try {

            $role = Role::create(['name' => $request->name]);

            $role->syncPermissions($request->permissions);

            if ($role) {
                $this->_response['data'] = $role;
                $this->setResponse(false, 'Role created successfully.');
                return response()->json($this->_response);
            }
        } catch (\Exception $e) {
            $this->setResponse(true, $e->getMessage());
            return response()->json($this->_response, 500);
        }
    }

    // Delete Role 
    public function delete(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
        ]);

        if ($validator->fails()) {
            $this->setResponse(true, $validator->errors()->all());
            return response()->json($this->_response, 400);
        }
        try {
            $roleDelete =  Role::find($request->id);
            if ($roleDelete) {
                $roleDelete->delete();
                $this->setResponse(false, 'Role deleted successfully from database.');
                return response()->json($this->_response);
            }
        } catch (\Exception $e) {
            $this->setResponse(true, $e->getMessage());
            return response()->json($this->_response, 500);
        }
    }

    // Add new role and assign permissions
    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'permissions' => 'required|array|min:1',
        ]);

        if ($validator->fails()) {
            $this->setResponse(true, $validator->errors()->all());
            return response()->json($this->_response, 400);
        }

        try {

            $role = Role::findOrFail($request->id);

            // return response()->json($role->syncPermissions($request->permissions));
            $role->syncPermissions($request->permissions);
            $sourceName = auth()->id();
            $users = User::find($sourceName);
            $sourceId = $users ? $users->first_name : 'Unknown User';
            $message = $role->name.'_permission_updated';
            $var = AmcOption::updateOrCreate(
                ['key' => $message],
                ['value' => true]
            );
            if ($var) {
                // $this->sendRoleUpdates($message);
                $data = [
                    'updated_by' => $sourceId,
                    'activity' => 'Access rights Updated',
                    'activity_slug' =>Str::of('Access rights Updated')->slug('_'),
                    'target_name' => $role->name,
                    'details' => "Access rights for role '{$role->name}' updated",
                ];
                ActivityLog::log($data);
                // $this->_response['data'] = $role;
                $this->setResponse(false, 'Permission updated successfully.');
                return response()->json($this->_response);
            }
        } catch (\Exception $e) {
            $this->setResponse(true, $e->getMessage());
            return response()->json($this->_response, 500);
        }
    }
}
