<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Resources\NotificationsResource;
use App\Models\Notifications;
use App\Models\User;
use Illuminate\Support\Facades\Validator;

class NotificationsController extends Controller
{
    /**
     * Get notifications based on target_id for the authenticated user.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function getNotifications(Request $request)
    {
  // Get the authenticated user's ID from the session
  $userId = auth()->id();

  // Find notifications with the user's ID as target_id
  $notifications = Notifications::where('user_id', $userId)->where('is_read', 0)->get();

  $transformedNotifications = NotificationsResource::collection($notifications);

  // Return the transformed notifications as JSON response
  return response()->json(['notifications' => $transformedNotifications]);
    }

    /**
     * Mark a notification as read (is_read = 1) based on the notification ID.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function deleteNotifications(Request $request)
    {
      $validator = Validator::make($request->all(), [
        'notification_id' => 'nullable|exists:notifications,id'
    ]);

    if ($validator->fails()) {
        return response()->json(['errors' => $validator->errors()], 400);
    }

    try {
        $userId = auth()->id();

        if ($request->has('notification_id')) {
            // Find the notification
            $notification = Notifications::where('user_id', $userId)
                ->where('id', $request->notification_id)
                ->first();

            if (!$notification) {
                return response()->json(['message' => 'Notification not found'], 404);
            }

            // Update the notification to mark it as read
            $notification->update(['is_read' => 1]);

            return response()->json(['message' => 'Notification marked as read']);
        } else {
            // If no notification_id is provided, delete all notifications for the user
            Notifications::where('user_id', $userId)->update(['is_read' => 1]);

            return response()->json(['message' => 'All notifications marked as read']);
        }
    } catch (\Exception $e) {
        return response()->json(['message' => 'Failed to mark notifications as read'], 500);
    }
    }
}
