<?php

namespace App\Http\Controllers;

use App\Models\ActivityLog;
use App\Http\Resources\ActivityLogResource;
use Illuminate\Http\Request;

class ActivityLogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if (auth()->user()->getRole() == 'admin'){
            $activityLogsQuery = ActivityLog::query();

            // Check if "activity" filter parameter is provided
            if ($request->filled('activity_slug')) {
                $activity = $request->input('activity_slug');
                $activityLogsQuery->where('activity_slug', $activity);
            }

            $activityLogs = $activityLogsQuery->get();
            
            return ActivityLogResource::collection($activityLogs);
        }
    }
}
